<?php
// Supondo que o JSON vem de uma fonte externa, como uma requisição ou um arquivo
$json_data = '{
  "id": "00907e72-2694-4d21-ae59-bee19e74f030",
  "creation_date": 1729032673904,
  "event": "PURCHASE_APPROVED",
  "version": "2.0.0",
  "data": {
    "product": {
      "id": 0,
      "ucode": "fb056612-bcc6-4217-9e6d-2a5d1110ac2f",
      "name": "Produto test postback2",
      "has_co_production": false
    },
    "affiliates": [
      {
        "affiliate_code": "Q58388177J",
        "name": "Affiliate name"
      }
    ],
    "buyer": {
      "email": "testeComprador271101postman15@example.com",
      "name": "Teste Comprador",
      "checkout_phone": "99999999900",
      "address": {
        "country": "Brasil",
        "country_iso": "BR"
      }
    },
    "producer": {
      "name": "Producer Test Name"
    },
    "commissions": [
      {
        "value": 149.5,
        "source": "MARKETPLACE",
        "currency_value": "BRL"
      },
      {
        "value": 1350.5,
        "source": "PRODUCER",
        "currency_value": "BRL"
      }
    ],
    "purchase": {
      "approved_date": 1511783346000,
      "full_price": {
        "value": 1500,
        "currency_value": "BRL"
      },
      "price": {
        "value": 1500,
        "currency_value": "BRL"
      },
      "checkout_country": {
        "name": "Brasil",
        "iso": "BR"
      },
      "order_bump": {
        "is_order_bump": true,
        "parent_purchase_transaction": "HP02316330308193"
      },
      "original_offer_price": {
        "value": 1500,
        "currency_value": "BRL"
      },
      "order_date": 1511783344000,
      "status": "APPROVED",
      "transaction": "HP16015479281022",
      "payment": {
        "installments_number": 12,
        "type": "CREDIT_CARD"
      },
      "offer": {
        "code": "test"
      },
      "sckPaymentLink": "sckPaymentLinkTest"
    },
    "subscription": {
      "status": "ACTIVE",
      "plan": {
        "id": 123,
        "name": "plano de teste"
      },
      "subscriber": {
        "code": "I9OT62C3"
      }
    }
  },
  "hottok": "BpDU2FH1jGxKBE9bFV2RYHzBrjOZfO1044552"
}';

// Decodifica o JSON para um array PHP
$data = json_decode($json_data, true);

// Função para converter timestamp para uma data legível
function format_date($timestamp) {
    return date("d/m/Y H:i:s", $timestamp / 1000);
}

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detalhes da Compra</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; }
        .container { width: 60%; margin: auto; background: white; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        h1 { text-align: center; color: #333; }
        .section { margin-bottom: 20px; }
        .section h2 { border-bottom: 2px solid #ddd; padding-bottom: 10px; color: #555; }
        .info { padding: 10px 0; }
        .info span { font-weight: bold; }
    </style>
</head>
<body>

<div class="container">
    <h1>Informações da Compra</h1>
    
    <div class="section">
        <h2>Produto</h2>
        <div class="info"><span>Nome do Produto:</span> <?= $data['data']['product']['name'] ?></div>
        <div class="info"><span>Ucode do Produto:</span> <?= $data['data']['product']['ucode'] ?></div>
    </div>

    <div class="section">
        <h2>Comprador</h2>
        <div class="info"><span>Nome:</span> <?= $data['data']['buyer']['name'] ?></div>
        <div class="info"><span>Email:</span> <?= $data['data']['buyer']['email'] ?></div>
        <div class="info"><span>Telefone:</span> <?= $data['data']['buyer']['checkout_phone'] ?></div>
        <div class="info"><span>País:</span> <?= $data['data']['buyer']['address']['country'] ?> (<?= $data['data']['buyer']['address']['country_iso'] ?>)</div>
    </div>

    <div class="section">
        <h2>Produtor</h2>
        <div class="info"><span>Nome do Produtor:</span> <?= $data['data']['producer']['name'] ?></div>
    </div>

    <div class="section">
        <h2>Afiliado</h2>
        <div class="info"><span>Código do Afiliado:</span> <?= $data['data']['affiliates'][0]['affiliate_code'] ?></div>
        <div class="info"><span>Nome do Afiliado:</span> <?= $data['data']['affiliates'][0]['name'] ?></div>
    </div>

    <div class="section">
        <h2>Compra</h2>
        <div class="info"><span>Status da Compra:</span> <?= $data['data']['purchase']['status'] ?></div>
        <div class="info"><span>Data de Aprovação:</span> <?= format_date($data['data']['purchase']['approved_date']) ?></div>
        <div class="info"><span>Preço Total:</span> <?= $data['data']['purchase']['price']['value'] ?> <?= $data['data']['purchase']['price']['currency_value'] ?></div>
        <div class="info"><span>Transação:</span> <?= $data['data']['purchase']['transaction'] ?></div>
        <div class="info"><span>Número de Parcelas:</span> <?= $data['data']['purchase']['payment']['installments_number'] ?></div>
        <div class="info"><span>Tipo de Pagamento:</span> <?= $data['data']['purchase']['payment']['type'] ?></div>
    </div>

    <div class="section">
        <h2>Assinatura</h2>
        <div class="info"><span>Status:</span> <?= $data['data']['subscription']['status'] ?></div>
        <div class="info"><span>Plano:</span> <?= $data['data']['subscription']['plan']['name'] ?> (ID: <?= $data['data']['subscription']['plan']['id'] ?>)</div>
        <div class="info"><span>Código do Assinante:</span> <?= $data['data']['subscription']['subscriber']['code'] ?></div>
    </div>

</div>

</body>
</html>
