<?php

require 'config.php'; // Conexão com o banco de dados

try {
    // Decrementa 'dias_restantes' de todas as assinaturas que ainda têm dias restantes > 0
    $stmt = $conn->prepare("SELECT id, dias_restantes FROM assinaturas WHERE dias_restantes > 0");
    $stmt->execute();
    
    // Inicializa contador de atualizações
    $count = 0;

    // Atualiza cada assinatura decrementando os dias restantes
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $new_days_remaining = $row['dias_restantes'] - 1;
        $id_assinatura = $row['id'];

        // Decrementa os dias restantes
        $update_stmt = $conn->prepare("UPDATE assinaturas SET dias_restantes = ? WHERE id = ?");
        $update_stmt->execute([$new_days_remaining, $id_assinatura]);

        // Incrementa contador
        $count++;
    }

    // Verifica todas as assinaturas que têm dias_restantes igual a 0 e atualiza o status para 'Atrasada'
    $stmt_update_status = $conn->prepare("UPDATE assinaturas SET status_assinatura = 'Atrasada' WHERE dias_restantes = 0");
    $stmt_update_status->execute();

} catch (Exception $e) {
    // Caso ocorra uma exceção, lança o erro
    throw new Exception("Erro ao atualizar dias restantes: " . $e->getMessage());
}

?>
