<!doctype html>
<html lang="pt-br">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link href="css/bootstrap.min.css" rel="stylesheet">
        <link href="css/custom.css" rel="stylesheet">
        <title><?php echo PAGE_TITLE; ?></title>

        <!-- Google Tag Manager -->
        <script>
            (function (w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({'gtm.start': new Date().getTime(), event: 'gtm.js'});
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src = 'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', '<?php echo ID_GTM; ?>');
        </script>

        <script type="text/javascript">
            var contador = 7;

            function chamar() {
                if (contador > 0) {
                    document.getElementById('contador').innerHTML = --contador;
                }
            }

            function redirecionar() {
                var dispositivo = '<?php echo identificarDispositivo(); ?>';
                var linkIfoodMobile = "ifood://restaurant/<?php echo ID_RESTAURANTE; ?>";
                var linkIfoodWeb = "<?php echo LINK_RESTAURANTE; ?>";
                
                if (dispositivo === "mobile") {
                    window.location.href = linkIfoodMobile;
                    setTimeout(function () {
                        window.location.href = linkIfoodWeb;
                    }, 3000);
                } else {
                    window.location.href = linkIfoodWeb;
                }
            }

            setInterval(chamar, 1000);
            setTimeout(redirecionar, 7000);
        </script>
    </head>
    <body>
        <noscript>
            <iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo ID_GTM; ?>"
                          height="0" width="0" style="display:none;visibility:hidden"></iframe>
        </noscript>

        <div class="container-fluid">
            <div class="row">
                <div class="col-md-2 offset-md-5 text-center">
                    <img class="logo" src="images/<?php echo LOGO; ?>" alt="Logo">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 offset-md-3">
                    <div class="text-center">
                        <div class="spinner-border text-danger" style="width: 5rem; height: 5rem; margin: 50px 0;" role="status"></div>
                    </div>
                    <p class="text-center mensagem">
                        <?php echo MENSAGEM_PERSONALIZADA; ?>
                        <br>
                        Você será redirecionado(a) em <label id="contador">7</label> segundos.
                    </p>
                </div>
            </div>
        </div>

        <script src="js/bootstrap.bundle.min.js"></script>
    </body>
</html>
