<?php
// Inicia a sessão para acessar as variáveis de sessão
session_start();

// Incluir o arquivo de configuração do banco de dados
require 'config.php'; // Conexão com o banco de dados

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    // Redireciona para a página de login se não estiver logado
    header("Location: login.php");
    exit();
}

// Recupera o ID do usuário logado da sessão
$user_id = $_SESSION['user_id'];

// Verifica o status do plano do usuário
$sql = "SELECT dias_restantes FROM assinaturas WHERE usuario_id = ? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->execute([$user_id]);
$assinatura = $stmt->fetch(PDO::FETCH_ASSOC);

// Verifica se o plano está expirado
if ($assinatura && $assinatura['dias_restantes'] <= 0) {
    $plano_expirado = true;  // Definir variável para desabilitar funcionalidades
} else {
    $plano_expirado = false;
}

// Recupera os restaurantes do usuário logado
$sql = "SELECT * FROM restaurantes WHERE usuario_id = ?";
$stmt = $conn->prepare($sql);
$stmt->execute([$user_id]);
$restaurantes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Verifica se a requisição de exclusão foi feita
if (isset($_GET['delete']) && !$plano_expirado) { // Bloqueia exclusão se o plano estiver expirado
    $id_restaurante = $_GET['delete'];
    
    $sql = "DELETE FROM restaurantes WHERE id_restaurante = ? AND usuario_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$id_restaurante, $user_id]);

    header("Location: dashboard.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel de Restaurantes</title>

    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <link href="css/styles-dashboard.css" rel="stylesheet">
    <style>
        .disabled {
            pointer-events: none;
            opacity: 0.6;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Bem-vindo ao sistema!</h1>
            <div class="button-group">
                <button class="btn-secondary" onclick="window.location.href='configuracao.php'">Configurações</button>
                <button class="logout-button" onclick="window.location.href='logout.php'">Sair</button>
            </div>
        </div>

        <!-- Verifica se o plano está expirado e exibe a mensagem -->
        <?php if ($plano_expirado): ?>
            <div class="alert alert-danger mt-4" role="alert">
                Seu plano de assinatura expirou. Por favor, <a href="renovar_assinatura.php" class="alert-link">renove sua assinatura</a> para continuar usando o sistema.
            </div>
        <?php endif; ?>

        <div class="card mt-4">
            <h2>Restaurantes</h2>
            <!-- Desabilitar o botão "Adicionar Restaurante" se o plano estiver expirado -->
            <p><a href="add_restaurante.php" class="btn btn-primary <?php echo $plano_expirado ? 'disabled' : ''; ?>">
                <i class="fas fa-plus-circle"></i> Adicionar Restaurante
            </a></p>
            
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Título da Página</th>
                        <th>Slug</th>
                        <th>Logo</th>
                        <th>Link</th>
                        <th>Mensagem Personalizada</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($restaurantes as $restaurante): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($restaurante['id_restaurante']); ?></td>
                        <td><?php echo htmlspecialchars($restaurante['page_title']); ?></td>
                        <td><?php echo htmlspecialchars($restaurante['slug']); ?></td>
                        <td><img src="<?php echo $restaurante['logo']; ?>" alt="Logo" width="50"></td>
                        <td><?php echo htmlspecialchars($restaurante['link_restaurante']); ?></td>
                        <td><?php echo htmlspecialchars($restaurante['mensagem_personalizada']); ?></td>
                        <td class="action-buttons <?php echo $plano_expirado ? 'disabled' : ''; ?>">
                            <a href="edit_restaurante.php?id=<?php echo $restaurante['id_restaurante']; ?>" title="Editar">
                                <i class="fas fa-edit"></i>
                            </a>
                            <a href="?delete=<?php echo $restaurante['id_restaurante']; ?>" onclick="return confirm('Tem certeza que deseja excluir este restaurante?');" title="Excluir">
                                <i class="fas fa-trash-alt"></i>
                            </a>
                            <a href="/usuario_page.php?slug=<?php echo $restaurante['slug']; ?>" target="_blank" title="Ver Página">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>