<?php
// Inicia a sessão para acessar as variáveis de sessão
session_start();

// Habilitar exibição de erros no PHP para facilitar o diagnóstico (opcional em produção)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Incluir o arquivo de configuração do banco de dados
require 'config.php';

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    // Redireciona para a página de login se não estiver logado
    header("Location: login.php");
    exit();
}

// Obter o ID do usuário logado da sessão
$user_id = $_SESSION['user_id'];

// Verificar se a conexão com o banco de dados foi estabelecida corretamente
if (!isset($conn)) {
    die('Erro ao conectar ao banco de dados. Verifique as configurações.');
}

// Consulta SQL para buscar as assinaturas apenas do usuário logado
$sql = "SELECT id, usuario_id, transacao, plano, data_aprovacao, tipo_pagamento, status_compra, dias_restantes, status_assinatura 
        FROM assinaturas 
        WHERE usuario_id = ?";

try {
    // Prepara e executa a consulta usando o usuário logado como parâmetro
    $stmt = $conn->prepare($sql);
    $stmt->execute([$user_id]);

    // Busca todos os resultados em um array associativo
    $assinaturas = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    // Caso ocorra um erro, exibe a mensagem de erro
    die("Erro ao buscar assinaturas: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Assinaturas</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f5f5f5;
            color: #424242;
            padding-top: 20px;
        }

        .container {
            width: 80%;
            max-width: 1000px;
            margin: 0 auto;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background-color: #6200ea;
            padding: 20px;
            border-radius: 8px;
            color: #fff;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 500;
        }

        .header .button-group {
            display: flex;
            gap: 15px;
        }

        .button-group .btn-secondary, .logout-button {
            background-color: #03dac6;
            border: none;
            color: #fff;
            padding: 10px 15px;
            cursor: pointer;
            border-radius: 50px;
            transition: background-color 0.3s ease;
            text-decoration: none; /* Remover o sublinhado */
        }

        .button-group .btn-secondary:hover {
            background-color: #018786;
        }

        .logout-button {
            background-color: #ff5252;
        }

        .logout-button:hover {
            background-color: #ff1744;
        }

        h2 {
            margin-top: 20px;
            color: #6200ea;
            font-weight: bold;
            text-align: left;
        }

        .btn-primary {
            background-color: #6200ea;
            border: none;
            padding: 10px 20px;
            color: #fff;
            border-radius: 50px;
            transition: background-color 0.3s ease;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .btn-primary:hover {
            background-color: #3700b3;
        }

        table.table {
            border-collapse: collapse;
            width: 100%;
        }

        table th, table td {
            padding: 15px;
            text-align: left;
        }

        table th {
            color: #6200ea;
            font-weight: bold;
        }

        .card {
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            background-color: white;
            padding: 20px;
            margin-top: 20px;
        }

        p {
            text-align: center;
            font-size: 18px;
        }
    </style>
</head>
<body>

<div class="container">
    <!-- Cabeçalho com título e botões -->
    <div class="header">
        <h1>Lista de Assinaturas</h1>
        <div class="button-group">
            <a href="dashboard.php" class="btn-secondary">← Voltar ao Dashboard</a>
            <a href="logout.php" class="logout-button">Sair</a>
        </div>
    </div>

    <!-- Seção de Status da Assinatura -->
    <div class="card">
        <h2>Status da Assinatura</h2>
        <?php if (count($assinaturas) > 0): ?>
            <table class="table">
                <thead>
                    <tr>
                        <th>Dias Restantes</th>
                        <th>Status da Assinatura</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($assinaturas as $assinatura): ?>
                        <tr>
                            <td><?= htmlspecialchars($assinatura['dias_restantes']) ?></td>
                            <td><?= htmlspecialchars($assinatura['status_assinatura']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Nenhum status de assinatura encontrado.</p>
        <?php endif; ?>
    </div>

    <!-- Tabela principal de assinaturas -->
    <div class="card">
        <h2>Detalhes da Compra</h2>
        <?php if (count($assinaturas) > 0): ?>
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Data da Compra</th>
                        <th>Transação</th>
                        <th>Plano</th>
                        <th>Tipo de Pagamento</th>
                        <th>Status da Compra</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($assinaturas as $assinatura): ?>
                        <tr>
                            <td><?= htmlspecialchars($assinatura['id']) ?></td>
                            <td><?= date('d/m/Y H:i', strtotime($assinatura['data_aprovacao'])) ?></td>
                            <td><?= htmlspecialchars($assinatura['transacao']) ?></td>
                            <td><?= htmlspecialchars($assinatura['plano']) ?></td>
                            <td><?= htmlspecialchars($assinatura['tipo_pagamento']) ?></td>
                            <td><?= htmlspecialchars($assinatura['status_compra']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>Nenhuma assinatura encontrada.</p>
        <?php endif; ?>
    </div>
</div>

</body>
</html>