<?php
error_reporting(E_ALL); // Reporta todos os erros
ini_set('display_errors', 1); // Habilita a exibição de erros
session_start();
require 'config.php'; // Inclua sua configuração de banco de dados aqui

// Recupera o slug (nome amigável do restaurante) a partir dos parâmetros da URL
if (isset($_GET['slug'])) {
    $slug = $_GET['slug'];

    // Recupera os dados do restaurante do banco de dados
    $sql = "SELECT * FROM restaurantes WHERE slug = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$slug]);
    $restaurante = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verifica se o restaurante foi encontrado
    if (!$restaurante) {
        die("Restaurante não encontrado.");
    }

    // Verifica se o plano de assinatura do usuário expirou
    $sql_assinatura = "SELECT dias_restantes FROM assinaturas WHERE usuario_id = ? LIMIT 1";
    $stmt_assinatura = $conn->prepare($sql_assinatura);
    $stmt_assinatura->execute([$restaurante['usuario_id']]);
    $assinatura = $stmt_assinatura->fetch(PDO::FETCH_ASSOC);

    if ($assinatura && $assinatura['dias_restantes'] <= 0) {
        // Redireciona para uma página de aviso de plano expirado
        header("Location: /plano_expirado.php");
        exit();
    }

    // Recupera os dados de design do restaurante da tabela designs
    $sql = "SELECT * FROM designs WHERE id_restaurante = ?";
    $designStmt = $conn->prepare($sql);
    $designStmt->execute([$restaurante['id_restaurante']]);
    $design = $designStmt->fetch(PDO::FETCH_ASSOC);

    if (!$design) {
        // Se não encontrarmos informações de design, podemos definir valores padrão
        $design = [
            'logo_height' => '100px',
            'button_color' => '#5cb85c',
            'button_outline' => 0,
            'button_border_color' => '#5cb85c',
            'background_color' => '#ffffff', // Cor de fundo padrão
            'font_color_all' => '#000000', // Cor da fonte padrão
            'font_color_button' => '#FFFFFF' // Cor padrão do texto do botão
        ];
    }
} else {
    die("Slug do restaurante não fornecido.");
}

// Define constantes com os dados do restaurante e design
define("PAGE_TITLE", $restaurante['page_title']);
define("LOGO", $restaurante['logo']);
define("LOGO_HEIGHT", $design['logo_height']); 
define("ID_IFOOD", $restaurante['id_ifood']);
define("LINK_RESTAURANTE", $restaurante['link_restaurante']);
define("ID_GTM", $restaurante['id_gtm']);
define("MENSAGEM_PERSONALIZADA", $restaurante['mensagem_personalizada']);
define("DISABLE_REDIRECT", isset($restaurante['disable_redirect']) ? $restaurante['disable_redirect'] : 0); 
define("REDIRECT_TIME", isset($restaurante['redirect_time']) ? $restaurante['redirect_time'] : 7); 
define("BUTTON_ACTIVE", isset($restaurante['button_active']) ? $restaurante['button_active'] : 1); 
define("BUTTON_TEXT", isset($restaurante['button_text']) ? $restaurante['button_text'] : 'Visitar Restaurante');
define("FONT_COLOR_ALL", isset($design['font_color_all']) ? $design['font_color_all'] : '#000000'); // Cor padrão da fonte
define("FONT_COLOR_BUTTON", isset($design['font_color_button']) ? $design['font_color_button'] : '#FFFFFF'); // Cor padrão do texto do botão
define("BUTTON_COLOR", isset($design['button_color']) ? $design['button_color'] : '#5cb85c'); 
define("BUTTON_OUTLINE", isset($design['button_outline']) ? $design['button_outline'] : 0); 
define("BUTTON_BORDER_COLOR", isset($design['button_border_color']) ? $design['button_border_color'] : '#5cb85c'); 
define("BACKGROUND_COLOR", isset($design['background_color']) ? $design['background_color'] : '#ffffff');

// Função para identificar o tipo de dispositivo
function identificarDispositivo() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $mobileDevices = ['iPhone', 'iPad', 'Android', 'webOS', 'BlackBerry', 'iPod', 'Symbian', 'Windows Phone'];
    
    // Verificar se é um dispositivo mobile
    foreach ($mobileDevices as $device) {
        if (strpos($userAgent, $device) !== false) {
            return "mobile";
        }
    }
    return "desktop";
}
?>

<!doctype html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="/css/bootstrap.min.css" rel="stylesheet"> <!-- Caminho absoluto para CSS -->
    <link href="/css/custom.css" rel="stylesheet" />       <!-- Caminho absoluto para CSS -->
    <title><?php echo PAGE_TITLE; ?></title>

    <!-- Google Tag Manager -->
    <script>
        (function (w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({'gtm.start': new Date().getTime(), event: 'gtm.js'});
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src = 'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', '<?php echo ID_GTM; ?>');
    </script>
    <!-- Fim Google Tag Manager -->

    <script type="text/javascript">
    var contador = <?php echo REDIRECT_TIME; ?>; // Usar o tempo de redirecionamento do banco de dados

    function chamar() {
        var contadorElemento = document.getElementById('contador');
        if (contadorElemento && contador > 0) {
            contadorElemento.innerHTML = --contador;
        }
    }

    function redirecionar() {
        var dispositivo = '<?php echo identificarDispositivo(); ?>';
        var linkIfoodMobile = "ifood://restaurant/<?php echo ID_IFOOD; ?>";
        var linkIfoodWeb = "<?php echo LINK_RESTAURANTE; ?>";
        
        if (dispositivo === "mobile") {
            // Tentar abrir o link do app
            window.location.href = linkIfoodMobile;

            // Se o app não estiver instalado, redireciona diretamente para o site do restaurante no iFood
            setTimeout(function () {
                window.location.href = linkIfoodWeb;
            }, 3000); // Espera 3 segundos para verificar se o app foi aberto
        } else {
            // Redirecionar diretamente para a versão web no desktop
            window.location.href = linkIfoodWeb;
        }
    }

    // Inicializa o redirecionamento se o redirecionamento estiver habilitado
    document.addEventListener('DOMContentLoaded', function() {
        <?php if (DISABLE_REDIRECT == 0): ?>
            setInterval(chamar, 1000);
            setTimeout(redirecionar, contador * 1000); // Redireciona após o tempo definido
        <?php endif; ?>
    });
</script>
    <style>
        .logo {
        height: <?php echo LOGO_HEIGHT . 'px'; ?>; /* Altura configurável da logo em pixels */
        width: auto; /* Largura ajustada automaticamente */
        display: block;
        margin: 0 auto; /* Centraliza a logo */
        }

        .btn-custom {
            background-color: <?php echo BUTTON_COLOR; ?>; /* Cor do botão */
            color: <?php echo FONT_COLOR_BUTTON; ?>; /* Cor do texto do botão */
            border: <?php echo BUTTON_OUTLINE ? '1px solid ' . BUTTON_BORDER_COLOR : 'none'; ?>; /* Contorno do botão */
            border-radius: 5px; /* Bordas arredondadas */
            padding: 10px 15px; /* Espaçamento dentro do botão */
            text-decoration: none; /* Remove decoração do texto */
            text-align: center; /* Centraliza o texto */
            display: inline-block; /* Permite o uso de padding e margin adequadamente */
            transition: background-color 0.3s, color 0.3s; /* Transições de cor suave */
        }

        .btn-custom:hover {
            opacity: 0.8; /* Efeito ao passar o mouse */
        }

        body {
            background-color: <?php echo BACKGROUND_COLOR; ?>; /* Cor de fundo personalizável */
            color: <?php echo FONT_COLOR_ALL; ?>; /* Cor da fonte */
        }
    </style>
</head>
<body>
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo ID_GTM; ?>" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- Fim Google Tag Manager (noscript) -->

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 offset-md-5 text-center">
                <img class="logo" src="<?php echo LOGO; ?>" alt="Logo" width="100"> <!-- Logo com altura configurável -->
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 offset-md-3">
                <?php if (DISABLE_REDIRECT == 0): ?>
                    <div class="text-center">
                        <div class="spinner-border text-danger" style="width: 5rem; height: 5rem; margin: 50px 0;" role="status"></div>
                        <p class="text-center mensagem">
                            <?php echo MENSAGEM_PERSONALIZADA; ?>
                            <br>
                            Você será redirecionado(a) em <label id="contador"><?php echo REDIRECT_TIME; ?></label> segundos.
                        </p>
                    </div>
                <?php else: ?>
                    <div class="text-center">
                        <p class="text-center mensagem"><?php echo MENSAGEM_PERSONALIZADA; ?></p>
                    </div>
                <?php endif; ?>

                <!-- Renderiza o botão apenas se BUTTON_ACTIVE for 0 -->
                <?php if (BUTTON_ACTIVE == 0): ?>
                    <p class="text-center">
                        <a href="<?php echo LINK_RESTAURANTE; ?>" class="btn btn-custom"><?php echo BUTTON_TEXT; ?></a>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script src="/js/bootstrap.bundle.min.js"></script> <!-- Caminho absoluto para JS -->
</body>
</html>
