<?php
// Ativar exibição de erros
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require 'config.php'; // Inclua sua configuração de banco de dados aqui

// Inicializa a variável de erro
$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $login = $_POST['login']; // Pode ser usuário ou email

    // Verifica se o login é um email ou um nome de usuário
    if (filter_var($login, FILTER_VALIDATE_EMAIL)) {
        $sql = "SELECT * FROM usuarios WHERE email = ?";
    } else {
        $sql = "SELECT * FROM usuarios WHERE username = ?";
    }

    $stmt = $conn->prepare($sql);
    $stmt->execute([$login]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Gera um token de recuperação de senha (pode ser melhorado, ex: usar hash seguro)
        $token = bin2hex(random_bytes(32));

        // Salva o token no banco de dados com uma validade de 1 hora
        $sql = "UPDATE usuarios SET password_reset_token = ?, password_reset_expires = DATE_ADD(NOW(), INTERVAL 1 HOUR) WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$token, $user['id']]);

        // Gera o link de recuperação de senha
        $reset_link = "https://yourdomain.com/reset_pass.php?token=" . $token;

        // Prepara os dados do email para a API Brevo com um design bonito
        $emailData = [
            "sender" => [
                "name" => "Ifood Service",
                "email" => "reinventecomu@gmail.com"
            ],
            "to" => [
                [
                    "email" => $user['email'],
                    "name" => $user['username']
                ]
            ],
            "subject" => "Recuperação de Senha",
            "htmlContent" => "
            <html>
            <head>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        background-color: #f4f4f4;
                        color: #333333;
                        margin: 0;
                        padding: 20px;
                    }
                    .email-container {
                        background-color: #ffffff;
                        padding: 20px;
                        margin: auto;
                        width: 100%;
                        max-width: 600px;
                        border-radius: 10px;
                        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
                    }
                    .email-header {
                        background-color: #5cb85c;
                        color: #ffffff;
                        padding: 10px;
                        text-align: center;
                        border-radius: 10px 10px 0 0;
                    }
                    .email-body {
                        padding: 20px;
                        line-height: 1.6;
                    }
                    .email-footer {
                        text-align: center;
                        padding: 10px;
                        font-size: 12px;
                        color: #777777;
                    }
                    a {
                        color: #5cb85c;
                        text-decoration: none;
                    }
                    a:hover {
                        text-decoration: underline;
                    }
                    .button {
                        background-color: #5cb85c;
                        color: white;
                        padding: 10px 20px;
                        text-align: center;
                        border-radius: 5px;
                        text-decoration: none;
                        display: inline-block;
                        margin: 10px 0;
                    }
                    .button:hover {
                        background-color: #4cae4c;
                    }
                </style>
            </head>
            <body>
                <div class='email-container'>
                    <div class='email-header'>
                        <h2>Recuperação de Senha</h2>
                    </div>
                    <div class='email-body'>
                        <p>Olá <strong>{$user['username']}</strong>,</p>
                        <p>Recebemos uma solicitação para redefinir sua senha. Use o link abaixo para redefinir sua senha:</p>
                        <p><a href='$reset_link' class='button'>Redefinir Senha</a></p>
                        <p>Se você não solicitou esta alteração, ignore este email.</p>
                    </div>
                    <div class='email-footer'>
                        <p>Ifood Service © 2024</p>
                    </div>
                </div>
            </body>
            </html>",
            "textContent" => "Olá, {$user['username']},\nRecebemos uma solicitação para redefinir sua senha. Use o link abaixo para redefinir sua senha: $reset_link\nSe você não solicitou esta alteração, ignore este email."
        ];

        // Função para enviar o e-mail via API da Brevo
        $result = sendEmailWithBrevoAPI($emailData);

        if ($result['success']) {
            $success_message = "Um link de recuperação de senha foi enviado para o seu email.";
        } else {
            $error = "Erro ao enviar o email de recuperação. Tente novamente mais tarde.";
        }
    } else {
        $error = "Usuário/email não encontrado.";
    }
}

// Função para enviar e-mail usando a API Brevo
function sendEmailWithBrevoAPI($data) {
    $apiKey = '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'; // Substitua pela sua chave de API
    $url = 'https://api.brevo.com/v3/smtp/email';

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'Content-Type: application/json',
        'api-key: ' . $apiKey
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode == 201) {
        return ['success' => true];
    } else {
        return ['success' => false, 'response' => $response];
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Recuperar Senha</title>
    <link rel="stylesheet" href="/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .container {
            max-width: 400px;
            margin-top: 80px;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .form-control {
            border-radius: 8px;
            margin-bottom: 15px;
        }
        .btn-primary {
            background-color: #5cb85c;
            border-color: #5cb85c;
            border-radius: 30px;
            padding: 10px 20px;
            width: 100%;
        }
        .btn-primary:hover {
            background-color: #4cae4c;
        }
        .error {
            color: red;
            text-align: center;
            margin-bottom: 15px;
        }
        .alert-success {
            text-align: center;
        }
        p a {
            color: #5cb85c;
        }
        p a:hover {
            text-decoration: underline;
            color: #4cae4c;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Recuperar Senha</h2>
        <?php if (!empty($error)) { echo "<p class='error'>$error</p>"; } ?>
        <?php if (isset($success_message)) { echo "<p class='alert alert-success'>$success_message</p>"; } ?>
        <form action="" method="POST">
            <div class="mb-3">
                <label for="login">Usuário ou Email:</label>
                <input type="text" class="form-control" name="login" required>
            </div>
            <button type="submit" class="btn btn-primary">Enviar Link de Recuperação</button>
        </form>
        <p class="mt-2">Lembrou da sua senha? <a href="login.php">Faça login</a></p>
    </div>

    <script src="/js/bootstrap.bundle.min.js"></script>
</body>
</html>
