<?php
// Conectar ao banco de dados
$dsn = 'mysql:host=localhost;dbname=saas_database';
$username = 'db_user';
$password = 'db_password';
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $username, $password, $options);
} catch (PDOException $e) {
    die('Erro ao conectar ao banco de dados: ' . $e->getMessage());
}

// Obter configurações do cliente baseado no subdomínio ou id na URL
$clientId = $_GET['cliente_id']; // Ou baseado no subdomínio do cliente
$query = "SELECT * FROM configuracoes WHERE id = :id";
$stmt = $pdo->prepare($query);
$stmt->execute(['id' => $clientId]);
$config = $stmt->fetch();

// Caso não encontre configurações para o cliente
if (!$config) {
    die('Configurações não encontradas.');
}

// Definir constantes baseadas nas configurações do cliente
define("PAGE_TITLE", $config['page_title']);
define("LOGO", $config['logo']);
define("ID_RESTAURANTE", $config['id_restaurante']);
define("LINK_RESTAURANTE", $config['link_restaurante']);
define("ID_GTM", $config['id_gtm']);
define("MENSAGEM_PERSONALIZADA", $config['mensagem_personalizada']);

function identificarDispositivo() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $mobileDevices = ['iPhone', 'iPad', 'Android', 'webOS', 'BlackBerry', 'iPod', 'Symbian', 'Windows Phone'];
    
    foreach ($mobileDevices as $device) {
        if (strpos($userAgent, $device) !== false) {
            return "mobile";
        }
    }
    return "desktop";
}
?>
