<?php
// Configurações de relatórios de erros
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require 'config.php'; // Conexão com o banco de dados

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Obtém o ID do restaurante da query string
$id_restaurante = $_GET['id'] ?? null;

if ($id_restaurante) {
    // Prepara e executa a consulta para obter os dados do restaurante
    $stmt = $conn->prepare("SELECT * FROM restaurantes WHERE id_restaurante = ?");
    $stmt->execute([$id_restaurante]);
    $restaurante = $stmt->fetch(PDO::FETCH_ASSOC);

    // Prepara e executa a consulta para obter os dados de design
    $stmt = $conn->prepare("SELECT * FROM designs WHERE id_restaurante = ?");
    $stmt->execute([$id_restaurante]);
    $design = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verifica se o restaurante foi encontrado
    if (!$restaurante) {
        die("Restaurante não encontrado.");
    }

    // Define constantes para uso posterior
    define("PAGE_TITLE", $restaurante['page_title']);
    define("LOGO", $restaurante['logo']);
    define("LOGO_HEIGHT", $design['logo_height']);
    define("ID_IFOOD", $restaurante['id_ifood']);
    define("LINK_RESTAURANTE", $restaurante['link_restaurante']);
    define("ID_GTM", $restaurante['id_gtm']);
    define("MENSAGEM_PERSONALIZADA", $restaurante['mensagem_personalizada']);
    define("DISABLE_REDIRECT", $restaurante['disable_redirect'] ?? 0);
    define("REDIRECT_TIME", $restaurante['redirect_time'] ?? 7);
    define("BUTTON_ACTIVE", $restaurante['button_active'] ?? 1);
    define("BUTTON_TEXT", $restaurante['button_text'] ?? 'Visitar Restaurante');
    define("BUTTON_COLOR", $design['button_color'] ?? '#5cb85c');
    define("BUTTON_OUTLINE", $design['button_outline'] ?? 0);
    define("BUTTON_BORDER_COLOR", $design['button_border_color'] ?? '#5cb85c');
    define("PAGE_BACKGROUND_COLOR", $design['background_color'] ?? '#ffffff');  // A cor de fundo

    // Processa o formulário de edição
    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        // Sanitiza e valida os dados do formulário
        $page_title = $_POST['page_title'] ?? '';
        $id_ifood = $_POST['id_ifood'] ?? '';
        $link_restaurante = $_POST['link_restaurante'] ?? '';
        $id_gtm = $_POST['id_gtm'] ?? '';
        $mensagem_personalizada = $_POST['mensagem_personalizada'] ?? '';
        $redirect_time = intval($_POST['redirect_time'] ?? 7);
        $button_active = isset($_POST['button_active']) ? 1 : 0;
        $button_text = $_POST['button_text'] ?? '';
        $button_color = $_POST['button_color'] ?? '';
        $button_outline = isset($_POST['button_outline']) ? 1 : 0;
        $button_border_color = $_POST['button_border_color'] ?? '';
        $logo_height = $_POST['logo_height'] ?? '';
        $disable_redirect = isset($_POST['disable_redirect']) ? 1 : 0;
        $font_color_button = $_POST['font_color_button'] ?? '#000000';  // Captura o valor da cor da fonte
        $page_background_color = $_POST['page_background_color'] ?? '#ffffff';  // Captura o valor da cor de fundo

        // Upload de logo (se necessário)
        $logo_path = LOGO; // Mantém o caminho da logo atual
        if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
            $fileTmpPath = $_FILES['logo']['tmp_name'];
            $fileName = $_FILES['logo']['name'];
            $user_id = $_SESSION['user_id'];
            $restaurantDirectory = 'restaurante/' . $user_id;

            // Cria o diretório do restaurante, se não existir
            if (!file_exists($restaurantDirectory)) {
                mkdir($restaurantDirectory, 0755, true);
            }

            // Define o novo caminho da logo
            $logo_path = $restaurantDirectory . '/' . basename($fileName);

            // Move o arquivo enviado para o diretório do restaurante
            if (!move_uploaded_file($fileTmpPath, $logo_path)) {
                die("Erro ao mover o arquivo de logo.");
            }
        }

        // Atualiza os dados do restaurante
        $stmt = $conn->prepare("UPDATE restaurantes SET page_title = ?, id_ifood = ?, link_restaurante = ?, id_gtm = ?, mensagem_personalizada = ?, disable_redirect = ?, redirect_time = ?, button_text = ?, button_active = ?, logo = ? WHERE id_restaurante = ?");
        $stmt->execute([$page_title, $id_ifood, $link_restaurante, $id_gtm, $mensagem_personalizada, $disable_redirect, $redirect_time, $button_text, $button_active, $logo_path, $id_restaurante]);

        // Atualiza os dados de design, incluindo a cor da fonte do botão e a cor de fundo
        $stmt = $conn->prepare("UPDATE designs SET logo_height = ?, button_color = ?, button_outline = ?, button_border_color = ?, font_color_button = ?, background_color = ? WHERE id_restaurante = ?");
        $stmt->execute([$logo_height, $button_color, $button_outline, $button_border_color, $font_color_button, $page_background_color, $id_restaurante]);

        // Redireciona para o dashboard após a atualização
        header("Location: dashboard.php");
        exit();
    }
} else {
    die("ID do restaurante não especificado.");
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Editar Restaurante</title>
<link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
<link href="css/styles-edit-restaurante.css" rel="stylesheet">

</head>
<body>
<div class="container mt-5">
  <h1 class="mb-4">Editar Restaurante</h1>
  <form action="" method="POST" enctype="multipart/form-data">
    <!-- Campos do formulário -->
    <div class="form-group">
      <label for="page_title">Título da Página:</label>
      <input type="text" class="form-control" name="page_title" value="<?= htmlspecialchars(PAGE_TITLE); ?>" required>
    </div>
    <div class="form-group">
      <label for="logo">Logo (upload opcional):</label>
      <input type="file" class="form-control-file" name="logo" accept="image/*">
      <small class="form-text text-muted">Se selecionar um novo arquivo, a logo atual será substituída.</small> 
    </div>
    <div class="form-group">
      <label for="logo_height">Tamanho da Logo:</label>
      <input type="range" class="form-control-range" name="logo_height" id="logo_height" min="50" max="300" value="<?= htmlspecialchars(LOGO_HEIGHT); ?>" oninput="document.getElementById('logo_height_value').textContent = this.value + 'px';">
      <small>Altura selecionada: <span id="logo_height_value"><?= htmlspecialchars(LOGO_HEIGHT); ?>px</span></small> 
    </div>
    <div class="form-group">
      <label for="link_restaurante">Link do Restaurante:</label>
      <input type="text" class="form-control" name="link_restaurante" value="<?= htmlspecialchars(LINK_RESTAURANTE); ?>" required>
    </div>
    <div class="form-group">
      <label for="id_ifood">ID do iFood:</label>
      <input type="text" class="form-control" name="id_ifood" value="<?= htmlspecialchars(ID_IFOOD); ?>" required>
    </div>
    <div class="form-group">
      <label for="id_gtm">ID GTM:</label>
      <input type="text" class="form-control" name="id_gtm" value="<?= htmlspecialchars(ID_GTM); ?>" >
    </div>
    <div class="form-group">
      <label for="mensagem_personalizada">Mensagem Personalizada:</label>
      <textarea class="form-control" name="mensagem_personalizada" required><?= htmlspecialchars(MENSAGEM_PERSONALIZADA); ?></textarea>
    </div>
    <div class="form-group form-check">
      <input type="checkbox" class="form-check-input" name="disable_redirect" id="disable_redirect" <?= DISABLE_REDIRECT ? 'checked' : ''; ?> onchange="toggleRedirectTime()">
      <label for="disable_redirect" class="form-check-label">Desativar redirecionamento automático</label>
    </div>
    <div class="form-group">
      <label for="redirect_time">Tempo de Redirecionamento (em segundos):</label>
      <input type="number" class="form-control" name="redirect_time" id="redirect_time" value="<?= htmlspecialchars(REDIRECT_TIME); ?>" required>
    </div>
    <div class="form-group form-check">
      <input type="checkbox" class="form-check-input" name="button_active" id="button_active" <?= BUTTON_ACTIVE ? 'checked' : ''; ?> onchange="toggleButtonSettings()">
      <label for="button_active" class="form-check-label">Desativar Botão de Redirecionamento</label>
    </div>
    <div class="form-group">
      <label for="button_text">Texto do Botão:</label>
      <input type="text" class="form-control" name="button_text" id="button_text" value="<?= htmlspecialchars(BUTTON_TEXT); ?>" required>
    </div>
    <div class="form-group">
        <label for="button_color">Cor do Botão:</label>
        <input type="color" class="form-control" name="button_color" id="button_color" value="<?= htmlspecialchars(BUTTON_COLOR); ?>" required>
    </div>
    <div class="form-group">
        <label for="font_color_button">Cor da Fonte do Botão:</label>
        <input type="color" class="form-control" name="font_color_button" id="font_color_button" value="<?= htmlspecialchars($design['font_color_button'] ?? '#000000'); ?>" required>
    </div>
    <div class="form-group form-check">
        <input type="checkbox" class="form-check-input" name="button_outline" id="button_outline" <?= BUTTON_OUTLINE ? 'checked' : ''; ?> onchange="toggleButtonOutline()">
        <label for="button_outline" class="form-check-label">Ativar Contorno no Botão</label>
    </div>
    <div class="form-group">
        <label for="button_border_color">Cor do Contorno:</label>
        <input type="color" class="form-control" name="button_border_color" id="button_border_color" value="<?= htmlspecialchars(BUTTON_BORDER_COLOR); ?>" required>
    </div>
    <div class="form-group">
        <label for="page_background_color">Cor de Fundo da Página:</label>
        <input type="color" class="form-control" name="page_background_color" id="page_background_color" value="<?= htmlspecialchars(PAGE_BACKGROUND_COLOR); ?>" required>
    </div>

    <button type="submit" class="btn btn-primary">Salvar Alterações</button>
    <a href="dashboard.php" class="btn btn-secondary ml-2">← Voltar</a>
  </form>
</div>

<script>
    function toggleRedirectTime() {
        var disableRedirect = document.getElementById('disable_redirect').checked;
        var redirectTime = document.getElementById('redirect_time');
        
        if (disableRedirect) {
            redirectTime.disabled = true;
            redirectTime.required = false;
        } else {
            redirectTime.disabled = false;
            redirectTime.required = true;
        }
    }

    function toggleButtonSettings() {
        var buttonActive = document.getElementById('button_active').checked;
        var buttonText = document.getElementById('button_text');
        var buttonColor = document.getElementById('button_color');
        var fontColorButton = document.getElementById('font_color_button'); // Cor da fonte do botão

        if (!buttonActive) {
            buttonText.disabled = false;
            buttonText.required = true;
            buttonColor.disabled = false;
            buttonColor.required = true;
            fontColorButton.disabled = false; // Habilita a cor da fonte quando o botão está ativo
        } else {
            buttonText.disabled = true;
            buttonText.required = false;
            buttonColor.disabled = true;
            buttonColor.required = false;
            fontColorButton.disabled = true; // Desabilita a cor da fonte quando o botão está desativado
        }
    }

    function toggleButtonOutline() {
        var buttonOutline = document.getElementById('button_outline').checked;
        var buttonBorderColor = document.getElementById('button_border_color');

        if (!buttonOutline) {
            buttonBorderColor.disabled = true;
            buttonBorderColor.required = false;
        } else {
            buttonBorderColor.disabled = false;
            buttonBorderColor.required = true;
        }
    }

    // Chama as funções ao carregar a página para ajustar os estados dos campos
    toggleRedirectTime();
    toggleButtonSettings();  // Certifica que os campos estejam no estado correto ao carregar a página
    toggleButtonOutline();
</script>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
